<?php
/**
Author: Sinan Tekmil
Author URI: http://www.veblebi.com/
Script URI: http://www.veblebi.com/jquery-json-category-select/
v :1.00;
*/

$parent = $children = array();
$active_parent = 2; // aktif(active) parent 
$active_children = 5; // aktif children
for($i=1;$i<=10;$i++) {
	$parent[$i] = 'Parent-'.$i;
	for($c=1;$c<=4;$c++) {
		$children[$i][($c+$i)] = 'Children-'.$c.'/'.$i;
	}
}
if($children) {
	$cats = json_encode($children);
}
?>
<!DOCTYPE html>
<html lang="tr-TR">
<head>
<meta charset="UTF-8">
<title>Json category subcategory</title>
<style type="text/css">
#main {
	width:300px;
	border:1px solid #ddd;
	padding:10px;
	margin:0 auto;
	background:#F7F7F7;
}
div>label {width:100px;float:left;}
select {padding:4px;margin-bottom:6px;width:180px}
#footer {
	background:#F3F3F3;
	padding:20px;
	text-align:center;
	margin-top:20px;
}
</style>
<script src="https://code.jquery.com/jquery-2.2.3.js" integrity="sha256-laXWtGydpwqJ8JA+X9x2miwmaiKhn8tVmOVEigRNtP4=" crossorigin="anonymous"></script>
</head>
<body>
<div id="main">
	<div><h2>Ana, Alt Kategori, JSON</h2></div>
	<div>
		<label for="parent">Ana Kategori</label>
		<select id="parent">
			<option value="">Seçiniz</option>
			<?php 
				foreach($parent as $k => $pv):
				$slc = ($active_parent == $k) ? ' selected="selected"':null;
			?>
			<option value="<?php echo $k?>"<?php echo $slc?>><?php echo $pv?></option>
			<?php endforeach?>
		</select>
	</div>
	<div>
		<label for="children">Ana Kategori</label>
		<select id="children">
		<option value="">Select Parent</option>
		</select>
	</div>
</div>
<script type="text/javascript">
var cats = <?php echo ($cats) ? $cats : '""'?>;
var active_children = <?php echo ($active_children) ? $active_children : '""'?>;

$("#parent").on('change', function(){
	var id = $(this).val();
	if(id<1){
		$("#children").html('<option value="">Select Parent</option>');
		return false;
	}
	if(cats) {
		var json_cats = cats[id];
		$("#children").html('<option value="">Seçiniz</option>');
		var text = '';
		var slc = '';
		$.each( json_cats, function( key, value ){
			slc= '';
			if(active_children && active_children == key) {
				slc = ' selected="selected"';
			}
			text += '<option value="'+key+'"'+slc+'>'+value+'</option>';
		});
		$("#children").html(text);
	}
});
$("#parent").change();
</script>

<div id="footer">
	© 2016 <a href="http://www.veblebi.com/jquery-json-category-select/" target="_blank">Veblebi</a>
</div>
</body>
</html>